//
//  OSXConstants.h
//  OnePasswordOSX
//
//  Created by Roustem Karimov on 2012-07-23.
//  Copyright (c) 2012 AgileBits Inc. All rights reserved.
//

#ifndef OnePasswordOSX_OSXConstants_h
#define OnePasswordOSX_OSXConstants_h

#import <Foundation/Foundation.h>

#if WEBSTORE
//	#pragma message "WebStore"
	#define HOCKEY_APPID @"0b415fb338c1683454b33f7b793726c7"
	#define HOCKEY_APPID_HELPER @"a4869da96e1a5b392f703a228d6b81fe"
#else
//	#pragma message "AppStore"
	#define HOCKEY_APPID @"0a410c03872a718e1eac19a0a05b0230"
	#define HOCKEY_APPID_HELPER @"75a69e214acdb3379ebeab651bf0f880"
#endif

#define SECONDS_IN_MINUTE 60

#define HELPER_CORNER_RADIUS 5.0

#define OPQuitAppForUpdateDistributedNotification @"com.agilebits.onepassword.QuitAppForUpdate"
#define OPForceQuitMiniForUpdateDistributedNotification @"com.agilebits.onepassword.ForceQuitMiniAppForUpdate"

#define OPApplicationDidLockNotification @"OPApplicationDidLock" /* No thread guarantee */
#define OPApplicationDidUnlockNotification @"OPApplicationDidUnlock" /* No thread guarantee */

#define OPSearchIsActiveNotification @"OPSearchIsActiveNotification"
#define OPSearchCancelledNotification @"OPSearchCancelledNotification"

#define OPAvailableKeychainOverviewsDidChangeDistributedNotification @"com.agilebits.onepassword.AvailableKeychainOverviewsDidChange"

#define OPActiveProfileDidChangeDistributedNotification @"com.agilebits.onepassword.ActiveProfileDidChange"

#define OPSyncMonitorWillStartDistributedNotification @"com.agilebits.onepassword.syncMonitorWillStart"
#define OPSyncMonitorDidFinishDistributedNotification @"com.agilebits.onepassword.syncMonitorDidFinish"

#define B5UserAccountProfileUnlockedDistributedNotification @"com.agilebits.onepassword.userAccountProfileUnlocked"
#define B5UserAccountStateChangedDistributedNotification @"com.agilebits.onepassword.userAccountStateChanged"
#define B5UserAccountDeletedDistributedNotification @"com.agilebits.onepassword.userAccountDeleted"
#define B5UserAccountProfileDeletedDistributedNotification @"com.agilebits.onepassword.profileDeleted"

#define OPAutoLockDistributedNotification @"com.agilebits.onepassword.AutoLock"

#define OPExtensionClientConnectedNotification @"AGExtensionClientConnected"
#define OPExtensionClientDidBecomeVerifiedNotification @"AGExtensionClientAuthenticated"

#define OPPrefKeepHelperRunning @"KeepHelperRunning"
#define OPPrefSuppressKeepHelperRunningPrompt @"SuppressKeepHelperRunningPrompt"
#define OPPrefShowStatusItem @"ShowStatusItem"
#define OPPrefHelperWindowLocation @"HelperWindowLocation"

#define OPPrefShouldAddLicenseAtNextUnlock @"ShouldAddLicenseAtNextUnlock"

#define OPPrefMainWindowLayout @"MainWindowLayout"
#define OPMainWindowLayoutVertical @"V"
#define OPMainWindowLayoutHorizonal @"H"

#define settingLockTimeout @"LockTimeout"
#define defaultLockTimeout 5
#define settingLockOnIdle @"LockOnIdle"
#define settingLockOnSleep @"LockOnSleep"
#define settingLockOnScreenSaver @"LockOnScreenSaver"
#define settingLockOnMainAppExit @"LockOnMainAppExit"
#define settingLockOnUserSwitch @"LockOnUserSwitch"

#define settingClearPasteboardAfterTimeout @"ClearPasteboardAfterTimeout"
#define settingPasteboardClearTimeout @"PasteboardClearTimeout"
#define defaultPasteboardClearTimeout 90

#define OPPrefWelcomeWindowShown @"WelcomeWindowShown"

#define OPPrefCheckForSoftwareUpdatesEnabled @"CheckForSoftwareUpdatesEnabled"
#define OPPrefCheckForSoftwareUpdatesIncludeBetas @"CheckForSoftwareUpdatesIncludeBetas"
#define OPPrefShowBackupCompletedNotifications @"ShowBackupCompletedNotifications"
#define OPPrefCheckForSoftwareUpdatesInterval @"CheckForSoftwareUpdatesInterval"

#define OPPrefGlobalLockShortcutRecorderName @"GlobalLock"
#define OPPrefGlobalLockKey @"ShortcutRecorder GlobalLock"

#define OPPrefGlobalActivationShortcutRecorderName @"GlobalActivation"
#define OPPrefGlobalActivationKey @"ShortcutRecorder GlobalActivation"

#define OPPrefBrowserActivationShortcutRecorderName @"BrowserActivation"
#define OPPrefBrowserActivationKey @"ShortcutRecorder BrowserActivation"

#define OPPrefBrowserCodesigningRequirementDisabled @"BrowserCodesigningRequirementDisabled"
#define OPPrefSecureSettings @"SecureSettings"

#define settingAnimateFill @"animateFill"
#define OPPrefLenientURLMatch @"lenientURLMatch"
#define settingAutosubmit @"autosubmit"
#define settingAutosave @"autosave"
#define OPPrefUseOPVaultFormatByDefault @"useOPVaultFormatByDefault"

#define settingConcealPasswords OPPrefConcealPasswords
#define defaultConcealPasswords YES

#define OPPrefShowCopyUUIDItemMenu @"ShowCopyUUIDItemMenu"
#define OPPrefShowCopyJSONItemMenu @"ShowCopyJSONItemMenu"

#define OPPrefEnable3rdPartyIntegration @"Enable3rdPartyIntegration"

#define settingDisableMonospacedFont @"DisableMonospacedFont"
#define settingDisableCoreAnimation @"DisableCoreAnimation"

#define settingPassGenType @"PassGenType"
#define defaultPassGenType @"Random"
#define settingPassGenLength @"PassGenLength"
#define settingPassGenMinNumbers @"PassGenMinNumbers"
#define settingPassGenMinSymbols  @"PassGenMinSymbols"
#define settingPassGenAvoidAmbiguous @"PassGenAvoidAmbiguous"
#define settingPassGenAllowRepeats @"PassGenAllowRepeats"
#define settingPassGenSeparator @"PassGenSeparator"
#define settingPassGenDisplayAdvancedOptions @"PassGenDisplayAdvancedOptions"
#define settingPassGenCopyToClipboardOnClose @"PassGenCopyToClipboardOnClose"

#define OPPrefShowItemCounts @"ShowItemCounts"
#define OPPrefDisplaySidebarPasswords @"DisplaySidebarPasswords"
#define OPPrefDisplaySidebarBrowserExtensions @"DisplaySidebarBrowserExtensions"
#define OPPrefDontDisplayAttachmentFinishedDialog @"DontDisplayAttachmentFinishedDialog"

#define OPPrefSidebarState @"Sidebar_"
#define OPPrefDisableWarningForRunningFromDownloadsFolder @"DisableWarningForRunningFromDownloadsFolder"

#define OPPrefGoAndFillOpenInTabMode @"GoAndFillOpenInTabMode"

#define OPPrefWiFiSyncServerPort @"WiFiSyncServerPort"
// FOUNDATION_EXPORT NSString *OPPrefWiFiSyncServerEnabledKey;
#define OPPrefWiFiSyncServerEnabledKey @"WiFiSyncEnabled"


#define OPPrefCompletedEssentialSettings @"CompletedEssentialSettings"

extern NSString * const OPPrefHaveShownFrozenAlertForAccount;

typedef enum {
	layoutShelves = 0,
	layoutWidescreen = 1,
	layoutTraditional = 2
} MainWindowLayout;

typedef NS_ENUM(NSInteger, OPCloudKitInitiationType) {
	OPCloudKitSessionInitiationNone,
	OPCloudKitSessionInitiationFirstRunWindow,
	OPCloudKitSessionInitiationPrefsWindow,
	OPCloudKitSessionInitiationResetCloudKit,
	OPCloudKitSessionInitiationSync
};


// Helper Settings
#define settingUbiqiuityContainerName @"UbiquityContainerName"

// Clipboard Types
extern NSString *AGDataObjectPboardType;
extern NSString *AGAttachmentPboardType;

#define OPHelperWindowFlagsChangedNotification @"OPHelperWindowFlagsChanged"
#define OPMainWindowFlagsChangedNotification @"OPMainWindowFlagsChanged"

#if APPSTORE
    #define OPHelperUnlockedDistributedNotification @"com.agilebits.helperUnlocked.MAS"
#else
    #define OPHelperUnlockedDistributedNotification @"com.agilebits.helperUnlocked"
#endif

#define OPHelperSettingsChangedDistributedNotification @"com.agilebits.onepassword.HelperSettingsChanged"

#define OPDismissUpdateAlertDistributedNotification @"com.agilebits.dismissUpdateAlert"

typedef enum {
	OPHelperPopupModeAtMouse = 0,
	OPHelperPopupModeDefault, // either under status item or centered if there is not status item
	OPHelperPopupModeQuickFill,
	OPHelperPopupModeCentered
} OPHelperPopupMode;

// Connected Extensions Dictionary Keys
FOUNDATION_EXPORT NSString * const OPConnectedExtensionType;
FOUNDATION_EXPORT NSString * const OPConnectedExtensionRemoteAppName;

// Spotlight
FOUNDATION_EXPORT NSString * const OPItemMetadataFileExtension;
FOUNDATION_EXPORT NSString * const OPItemMetadataUTI;

#endif
